// priority: 100
// Credits to Sunekaer for showing examples, writing useful helper functions, and also writing a good portion of this script.
// Modified and adapted by R3GEN for Feed The Beast
// 2022-08-15
onEvent("rei.group", (event) => {
	//Group all items using NBT, mostly Tinker's Construct tools and parts
	const useNbt = [
		"tconstruct:crafting_station",
		"tconstruct:tinker_station",
		"tconstruct:part_builder",
		"tconstruct:tinkers_anvil",
		"tconstruct:scorched_anvil",
		"tconstruct:repair_kit",
		"tconstruct:pick_head",
		"tconstruct:hammer_head",
		"tconstruct:small_axe_head",
		"tconstruct:broad_axe_head",
		"tconstruct:small_blade",
		"tconstruct:broad_blade",
		"tconstruct:round_plate",
		"tconstruct:large_plate",
		"tconstruct:tool_binding",
		"tconstruct:tool_handle",
		"tconstruct:tough_handle",
		"tconstruct:pickaxe",
		"tconstruct:sledge_hammer",
		"tconstruct:vein_hammer",
		"tconstruct:mattock",
		"tconstruct:pickadze",
		"tconstruct:excavator",
		"tconstruct:hand_axe",
		"tconstruct:broad_axe",
		"tconstruct:kama",
		"tconstruct:scythe",
		"tconstruct:dagger",
		"tconstruct:sword",
		"tconstruct:cleaver",
		"enchanted_book",
		'simpleplanes:plane',
		'simpleplanes:large_plane',
		'simpleplanes:helicopter',
		'rftoolsutility:syringe',
		'immersiveengineering:shader',
		'quark:ancient_tome'
	];

	useNbt.forEach((id) => {
		const item = Item.of(id);
		const { namespace, path } = Utils.id(item.id);
		event.groupSameItem(
			`${namespace}:rei_groups/${path}`,
			item.getName(),
			item
		);
	});

	//Group potions
	event.groupSameItem(
		`minecraft:rei_groups/potion`,
		"Potions",
		"minecraft:potion"
	);

	//Group splash potions
	event.groupSameItem(
		`minecraft:rei_groups/splash_potion`,
		"Splash Potions",
		"minecraft:splash_potion"
	);

	//Group tipped arrows
	event.groupSameItem(
		`minecraft:rei_groups/tipped_arrow`,
		"Tipped Arrows",
		"minecraft:tipped_arrow"
	);

	//Group lingering potions
	event.groupSameItem(
		`minecraft:rei_groups/lingering_potion`,
		"Lingering Potions",
		"minecraft:lingering_potion"
	);

	//Group potion buckets using ignore nbt
	const potion_bucket_ie = Item.of("immersiveengineering:potion_bucket").ignoreNBT();
	const potion_bucket_tico = Item.of("tconstruct:potion_bucket").ignoreNBT();
	const all_potion_buckets = [potion_bucket_ie, potion_bucket_tico];

	event.groupItemsIf(
		`kubejs:rei_groups/potion_bucket`,
		"Potion Buckets",
		all_potion_buckets
	);

	//Group AE2 cables into multiple groups
	["glass", "covered", "smart", "covered_dense", "smart_dense"].forEach(
		(type) => {
			event.groupItemsByTag(
				`ae2:rei_groups/${type}_cables`,
				`${toMultiTitleCase(type)} Cables`,
				`ae2:${type}_cable`
			);
		}
	);

	//Group memory cards
	event.groupItemsByTag(
		`ae2:rei_groups/memory_cards`,
		`Memory Cards`,
		`ae2:memory_cards`
	);

	//Group single use casts (sand, clay)
	event.groupItemsByTag(
		`tconstruct:rei_groups/single_use`,
		`Single Use Casts`,
		`tconstruct:casts/single_use`
	);

	//Group multi use casts (gold)
	event.groupItemsByTag(
		`tconstruct:rei_groups/multi_use`,
		`Multi Use Casts`,
		`tconstruct:casts/multi_use`
	);

	//Group paint balls
	event.groupItems(
		"ae2:rei_groups/paint_balls",
		"Paint Balls",
		/^ae2:.*_paint_ball$/
	);

	//Group all filled buckets
	const filled_buckets = [
		'ars_nouveau:bucket_of_source',
		'create:chocolate_bucket',
		'create:honey_bucket',
		'createaddition:bioethanol_bucket',
		'createaddition:seed_oil_bucket',
		'experienceobelisk:raw_experience_bucket',
		'immersiveengineering:acetaldehyde_bucket',
		'immersiveengineering:biodiesel_bucket',
		'immersiveengineering:concrete_bucket',
		'immersiveengineering:creosote_bucket',
		'immersiveengineering:ethanol_bucket',
		'immersiveengineering:herbicide_bucket',
		'immersiveengineering:phenolic_resin_bucket',
		'immersiveengineering:plantoil_bucket',
		'immersiveengineering:redstone_acid_bucket',
		'jaopca:molten.apatite',
		'jaopca:molten.aquamarine',
		'jaopca:molten.certus_quartz',
		'jaopca:molten.cinnabar',
		'jaopca:molten.fluorite',
		'jaopca:molten.iesnium',
		'jaopca:molten.lapis',
		'jaopca:molten.niter',
		'jaopca:molten.ruby',
		'jaopca:molten.sapphire',
		'jaopca:molten.sulfur',
		'kubejsadditions:molten_plexiglass_bucket',
		'mekanism:brine_bucket',
		'mekanism:chlorine_bucket',
		'mekanism:ethene_bucket',
		'mekanism:heavy_water_bucket',
		'mekanism:hydrofluoric_acid_bucket',
		'mekanism:hydrogen_bucket',
		'mekanism:hydrogen_chloride_bucket',
		'mekanism:lithium_bucket',
		'mekanism:nutritional_paste_bucket',
		'mekanism:oxygen_bucket',
		'mekanism:sodium_bucket',
		'mekanism:steam_bucket',
		'mekanism:sulfuric_acid_bucket',
		'mekanism:sulfur_dioxide_bucket',
		'mekanism:sulfur_trioxide_bucket',
		'mekanism:superheated_sodium_bucket',
		'mekanism:uranium_hexafluoride_bucket',
		'mekanism:uranium_oxide_bucket',
		'mekanismgenerators:bioethanol_bucket',
		'mekanismgenerators:deuterium_bucket',
		'mekanismgenerators:fusion_fuel_bucket',
		'mekanismgenerators:tritium_bucket',
		'pneumaticcraft:biodiesel_bucket',
		'pneumaticcraft:diesel_bucket',
		'pneumaticcraft:etching_acid_bucket',
		'pneumaticcraft:ethanol_bucket',
		'pneumaticcraft:gasoline_bucket',
		'pneumaticcraft:kerosene_bucket',
		'pneumaticcraft:lpg_bucket',
		'pneumaticcraft:lubricant_bucket',
		'pneumaticcraft:memory_essence_bucket',
		'pneumaticcraft:oil_bucket',
		'pneumaticcraft:plastic_bucket',
		'pneumaticcraft:vegetable_oil_bucket',
		'pneumaticcraft:yeast_culture_bucket',
		'tconstruct:beetroot_soup_bucket',
		'tconstruct:blazing_blood_bucket',
		'tconstruct:blood_bucket',
		'tconstruct:earth_slime_bucket',
		'tconstruct:ender_slime_bucket',
		'tconstruct:honey_bucket',
		'tconstruct:liquid_soul_bucket',
		'tconstruct:magma_bucket',
		'tconstruct:molten_aluminum_bucket',
		'tconstruct:molten_amethyst_bronze_bucket',
		'tconstruct:molten_amethyst_bucket',
		'tconstruct:molten_brass_bucket',
		'tconstruct:molten_bronze_bucket',
		'tconstruct:molten_clay_bucket',
		'tconstruct:molten_cobalt_bucket',
		'tconstruct:molten_constantan_bucket',
		'tconstruct:molten_copper_bucket',
		'tconstruct:molten_debris_bucket',
		'tconstruct:molten_diamond_bucket',
		'tconstruct:molten_electrum_bucket',
		'tconstruct:molten_emerald_bucket',
		'tconstruct:molten_enderium_bucket',
		'tconstruct:molten_ender_bucket',
		'tconstruct:molten_glass_bucket',
		'tconstruct:molten_gold_bucket',
		'tconstruct:molten_hepatizon_bucket',
		'tconstruct:molten_invar_bucket',
		'tconstruct:molten_iron_bucket',
		'tconstruct:molten_lead_bucket',
		'tconstruct:molten_lumium_bucket',
		'tconstruct:molten_manyullyn_bucket',
		'tconstruct:molten_netherite_bucket',
		'tconstruct:molten_nickel_bucket',
		'tconstruct:molten_obsidian_bucket',
		'tconstruct:molten_osmium_bucket',
		'tconstruct:molten_pig_iron_bucket',
		'tconstruct:molten_quartz_bucket',
		'tconstruct:molten_queens_slime_bucket',
		'tconstruct:molten_refined_glowstone_bucket',
		'tconstruct:molten_refined_obsidian_bucket',
		'tconstruct:molten_rose_gold_bucket',
		'tconstruct:molten_signalum_bucket',
		'tconstruct:molten_silver_bucket',
		'tconstruct:molten_slimesteel_bucket',
		'tconstruct:molten_steel_bucket',
		'tconstruct:molten_tin_bucket',
		'tconstruct:molten_uranium_bucket',
		'tconstruct:molten_zinc_bucket',
		'tconstruct:mushroom_stew_bucket',
		'tconstruct:rabbit_stew_bucket',
		'tconstruct:scorched_stone_bucket',
		'tconstruct:seared_stone_bucket',
		'tconstruct:sky_slime_bucket',
		'tconstruct:venom_bucket',
		'thermal:creosote_bucket',
		'thermal:crude_oil_bucket',
		'thermal:ender_bucket',
		'thermal:glowstone_bucket',
		'thermal:heavy_oil_bucket',
		'thermal:latex_bucket',
		'thermal:light_oil_bucket',
		'thermal:redstone_bucket',
		'thermal:refined_fuel_bucket',
		'thermal:resin_bucket',
		'thermal:sap_bucket',
		'thermal:syrup_bucket',
		'thermal:tree_oil_bucket'
	]

	event.groupItems(
		"forge:rei_groups/filled_buckets",
		"Filled Buckets",
		filled_buckets
	);

	//Group Create Deco blocks, stairs, slabs, etc. but per type, not all variants together.
	//E.g. Pearl bricks stairs together
	createdeco_makeREIgroups("worn", event, null);
	createdeco_makeREIgroups("red", event, "minecraft:bricks");
	createdeco_makeREIgroups("blue", event, null);
	createdeco_makeREIgroups("scarlet", event, null);
	createdeco_makeREIgroups("dusk", event, null);
	createdeco_makeREIgroups("pearl", event, null);
	createdeco_makeREIgroups("dean", event, null);

	//Group Create Deco lamps
	event.groupItems(
		"createdeco:rei_groups/lamps",
		"Lamps",
		/^createdeco:.*_lamp$/
	);

	//Group Minecraft copper variants, including oxidized ones
	event.groupItems(
		"minecraft:rei_groups/copper_blocks",
		"Blocks of Copper",
		['minecraft:copper_block', 'minecraft:exposed_copper', 'minecraft:weathered_copper', 'minecraft:oxidized_copper', 'minecraft:waxed_copper_block', 'minecraft:waxed_exposed_copper', 'minecraft:waxed_weathered_copper', 'minecraft:waxed_oxidized_copper']
	);
	event.groupItems(
		"minecraft:rei_groups/cut_copper_blocks",
		"Cut Copper",
		['minecraft:cut_copper', 'minecraft:exposed_cut_copper', 'minecraft:weathered_cut_copper', 'minecraft:oxidized_cut_copper', 'minecraft:waxed_cut_copper', 'minecraft:waxed_exposed_cut_copper', 'minecraft:waxed_weathered_cut_copper', 'minecraft:waxed_oxidized_cut_copper']
	);
	event.groupItems(
		"minecraft:rei_groups/cut_copper_stairs",
		"Cut Copper Stairs",
		['minecraft:cut_copper_stairs', 'minecraft:exposed_cut_copper_stairs', 'minecraft:weathered_cut_copper_stairs', 'minecraft:oxidized_cut_copper_stairs', 'minecraft:waxed_cut_copper_stairs', 'minecraft:waxed_exposed_cut_copper_stairs', 'minecraft:waxed_weathered_cut_copper_stairs', 'minecraft:waxed_oxidized_cut_copper_stairs']
	);
	event.groupItems(
		"minecraft:rei_groups/cut_copper_slabs",
		"Cut Copper Slabs",
		['minecraft:cut_copper_slab', 'minecraft:exposed_cut_copper_slab', 'minecraft:weathered_cut_copper_slab', 'minecraft:oxidized_cut_copper_slab', 'minecraft:waxed_cut_copper_slab', 'minecraft:waxed_exposed_cut_copper_slab', 'minecraft:waxed_weathered_cut_copper_slab', 'minecraft:waxed_oxidized_cut_copper_slab']
	);

	//Group Tinkers Construct slimy blocks per variant
	event.groupItems(
		"tconstruct:rei_groups/earthslime_soils",
		"Earthslime Soils",
		['tconstruct:earth_slime_dirt', 'tconstruct:earth_vanilla_slime_grass', 'tconstruct:earth_earth_slime_grass', 'tconstruct:earth_sky_slime_grass', 'tconstruct:earth_ender_slime_grass', 'tconstruct:earth_ichor_slime_grass']
	);
	event.groupItems(
		"tconstruct:rei_groups/skyslime_soils",
		"Skyslime Soils",
		['tconstruct:sky_slime_dirt', 'tconstruct:sky_vanilla_slime_grass', 'tconstruct:sky_earth_slime_grass', 'tconstruct:sky_sky_slime_grass', 'tconstruct:sky_ender_slime_grass', 'tconstruct:sky_ichor_slime_grass']
	);
	event.groupItems(
		"tconstruct:rei_groups/enderslime_soils",
		"Enderslime Soils",
		['tconstruct:ender_slime_dirt', 'tconstruct:ender_vanilla_slime_grass', 'tconstruct:ender_earth_slime_grass', 'tconstruct:ender_sky_slime_grass', 'tconstruct:ender_ender_slime_grass', 'tconstruct:ender_ichor_slime_grass']
	);
	event.groupItems(
		"tconstruct:rei_groups/ichorslime_soils",
		"Ichor Soils",
		['tconstruct:ichor_slime_dirt', 'tconstruct:ichor_vanilla_slime_grass', 'tconstruct:ichor_earth_slime_grass', 'tconstruct:ichor_sky_slime_grass', 'tconstruct:ichor_ender_slime_grass', 'tconstruct:ichor_ichor_slime_grass']
	);
	event.groupItems(
		"tconstruct:rei_groups/bloodslime_soils",
		"Bloody Nylium",
		['tconstruct:blood_vanilla_slime_grass', 'tconstruct:blood_earth_slime_grass', 'tconstruct:blood_sky_slime_grass', 'tconstruct:blood_ender_slime_grass', 'tconstruct:blood_ichor_slime_grass']
	);

	//Group Create copper variants, including oxidized ones
	event.groupItems(
		"create:rei_groups/copper_shingles",
		"Copper Shingles",
		['create:copper_shingles', 'create:exposed_copper_shingles', 'create:weathered_copper_shingles', 'create:oxidized_copper_shingles', 'create:waxed_copper_shingles', 'create:waxed_exposed_copper_shingles', 'create:waxed_weathered_copper_shingles', 'create:waxed_oxidized_copper_shingles']
	);
	event.groupItems(
		"minecraft:rei_groups/copper_shingle_slabs",
		"Copper Shingle Slabs",
		['create:copper_shingle_slab', 'create:exposed_copper_shingle_slab', 'create:weathered_copper_shingle_slab', 'create:oxidized_copper_shingle_slab', 'create:waxed_copper_shingle_slab', 'create:waxed_exposed_copper_shingle_slab', 'create:waxed_weathered_copper_shingle_slab', 'create:waxed_oxidized_copper_shingle_slab']
	);
	event.groupItems(
		"minecraft:rei_groups/copper_shingle_stairs",
		"Copper Shingle Stairs",
		['create:copper_shingle_stairs', 'create:exposed_copper_shingle_stairs', 'create:weathered_copper_shingle_stairs', 'create:oxidized_copper_shingle_stairs', 'create:waxed_copper_shingle_stairs', 'create:waxed_exposed_copper_shingle_stairs', 'create:waxed_weathered_copper_shingle_stairs', 'create:waxed_oxidized_copper_shingle_stairs']
	);
	event.groupItems(
		"create:rei_groups/copper_tiles",
		"Copper Tiles",
		['create:copper_tiles', 'create:exposed_copper_tiles', 'create:weathered_copper_tiles', 'create:oxidized_copper_tiles', 'create:waxed_copper_tiles', 'create:waxed_exposed_copper_tiles', 'create:waxed_weathered_copper_tiles', 'create:waxed_oxidized_copper_tiles']
	);
	event.groupItems(
		"minecraft:rei_groups/copper_tile_slabs",
		"Copper Tile Slabs",
		['create:copper_tile_slab', 'create:exposed_copper_tile_slab', 'create:weathered_copper_tile_slab', 'create:oxidized_copper_tile_slab', 'create:waxed_copper_tile_slab', 'create:waxed_exposed_copper_tile_slab', 'create:waxed_weathered_copper_tile_slab', 'create:waxed_oxidized_copper_tile_slab']
	);
	event.groupItems(
		"minecraft:rei_groups/copper_tile_stairs",
		"Copper Tile Stairs",
		['create:copper_tile_stairs', 'create:exposed_copper_tile_stairs', 'create:weathered_copper_tile_stairs', 'create:oxidized_copper_tile_stairs', 'create:waxed_copper_tile_stairs', 'create:waxed_exposed_copper_tile_stairs', 'create:waxed_weathered_copper_tile_stairs', 'create:waxed_oxidized_copper_tile_stairs']
	);

	//Group Occultism rituals, since they look the same...
	event.groupItems(
		"occultism:rei_groups/ritual_dummy",
		"Rituals",
		/^occultism:ritual_dummy.*$/
	);

	//Group Compressium blocks together, per material variant
	//E.g. Group compressed lapis together
	compressium_makeREIgroups('minecraft:soul_sand', "soulsand", event)
	compressium_makeREIgroups('minecraft:coal_block', "coal", event)
	compressium_makeREIgroups('minecraft:lapis_block', "lapis", event)
	compressium_makeREIgroups('minecraft:redstone_block', "redstone", event)
	compressium_makeREIgroups('minecraft:iron_block', "iron", event)
	compressium_makeREIgroups('minecraft:gold_block', "gold", event)
	compressium_makeREIgroups('minecraft:diamond_block', "diamond", event)
	compressium_makeREIgroups('minecraft:netherite_block', "netherite", event)
	compressium_makeREIgroups('minecraft:copper_block', "copper", event)
	compressium_makeREIgroups('minecraft:emerald_block', "emerald", event)
	compressium_makeREIgroups('minecraft:diorite', "diorite", event)
	compressium_makeREIgroups('minecraft:granite', "granite", event)
	compressium_makeREIgroups('minecraft:andesite', "andesite", event)
	compressium_makeREIgroups('minecraft:end_stone', "endstone", event)
	compressium_makeREIgroups('minecraft:sand', "sand", event)
	compressium_makeREIgroups('minecraft:red_sand', "redsand", event)
	compressium_makeREIgroups('minecraft:netherrack', "netherrack", event)
	compressium_makeREIgroups('minecraft:gravel', "gravel", event)
	compressium_makeREIgroups('minecraft:dirt', "dirt", event)
	compressium_makeREIgroups('minecraft:stone', "stone", event)
	compressium_makeREIgroups('minecraft:cobblestone', "cobblestone", event)
	compressium_makeREIgroups('minecraft:quartz_block', "quartz", event)
	compressium_makeREIgroups('minecraft:snow_block', "snow", event)
	compressium_makeREIgroups('minecraft:clay', "clay", event)
	compressium_makeREIgroups('minecraft:obsidian', "obsidian", event)

	//Group Oh My Gourd pumpkins... onto the Minecraft pumpkin!
	let carved_pumpkin_1 = ['minecraft:carved_pumpkin'];
	let carved_pumpkin_2 = Ingredient.of(/^omgourd:c.*$/).getItemIds();
	let all_carved_pumpkins = carved_pumpkin_1.concat(carved_pumpkin_2)

	event.groupItems(
		"minecraft:rei_groups/carved_pumpkins",
		"Carved Pumpkins",
		all_carved_pumpkins
	);

	//Group Jack O Lanters, same thing
	let jack_o_lantern_1 = ['minecraft:jack_o_lantern'];
	let jack_o_lantern_2 = Ingredient.of(/^omgourd:j.*$/).getItemIds();
	let all_jack_o_lanterns = jack_o_lantern_1.concat(jack_o_lantern_2)

	event.groupItems(
		"minecraft:rei_groups/jack_o_lanterns",
		"Jack O'Lanterns",
		all_jack_o_lanterns
	);
});

//original_block: The id of the block that the compressed version represents
//compressium_material_name: The name of the compressed material
//e: The KubeJS event object on "rei.group"
function compressium_makeREIgroups(original_block, compressium_material_name, e)  {
	let block_title = original_block.split(":")[1];
	e.groupItems(
		`compressium:rei_groups/${compressium_material_name}`,
		`Compressed ${toMultiTitleCase(block_title)}`,
		[original_block, `compressium:${compressium_material_name}_1`, `compressium:${compressium_material_name}_2`, `compressium:${compressium_material_name}_3`, `compressium:${compressium_material_name}_4`, `compressium:${compressium_material_name}_5`, `compressium:${compressium_material_name}_6`, `compressium:${compressium_material_name}_7`, `compressium:${compressium_material_name}_8`, `compressium:${compressium_material_name}_9`]
	);
}

//variant_name: The name of the variant which has bricks, stairs, etc.
//e: The KubeJS event object on "rei.group"
//first_brick_replacement: A string of the first brick, or null if the first brick doesn't change
//returns nothing
function createdeco_makeREIgroups(variant_name, e, first_brick_replacement) {
	//Assume all bricks are normal, then if we need to change the first one, do so
	let bricks = createdeco_getfullbricks(variant_name);
	if(first_brick_replacement != null) {
		bricks[0] = first_brick_replacement;
	}
	
	//Using the previous bricks array with the correct values, make a group
	e.groupItems(
		`createdeco:rei_groups/${variant_name}_bricks`,
		`${toMultiTitleCase(variant_name)} Bricks`,
		bricks
	);

	//Make a group for the stairs
	e.groupItems(
		`createdeco:rei_groups/${variant_name}_bricks_stairs`,
		`${toMultiTitleCase(variant_name)} Bricks Stairs`,
		createdeco_getstairs(variant_name)
	);

	//Make a group for the slabs
	e.groupItems(
		`createdeco:rei_groups/${variant_name}_bricks_slabs`,
		`${toMultiTitleCase(variant_name)} Bricks Slabs`,
		createdeco_getslabs(variant_name)
	);

	//Make a group for the vertical slabs
	e.groupItems(
		`createdeco:rei_groups/${variant_name}_bricks_slabs_vert`,
		`${toMultiTitleCase(variant_name)} Bricks Vertical Slabs`,
		createdeco_getvertslabs(variant_name)
	);

	//Make a group for the walls
	e.groupItems(
		`createdeco:rei_groups/${variant_name}_bricks_slabs_wall`,
		`${toMultiTitleCase(variant_name)} Bricks Walls`,
		createdeco_getwalls(variant_name)
	);
}

//variant_name: The name of the bricks variant
//returns an array of brick variants from create deco
function createdeco_getfullbricks(variant_name) {
	return [`createdeco:${variant_name}_bricks`, `createdeco:${variant_name}_brick_tiles`, `createdeco:${variant_name}_long_bricks`, `createdeco:${variant_name}_short_bricks`, `createdeco:cracked_${variant_name}_bricks`, `createdeco:cracked_${variant_name}_brick_tiles`, `createdeco:cracked_${variant_name}_long_bricks`, `createdeco:cracked_${variant_name}_short_bricks`, `createdeco:mossy_${variant_name}_bricks`, `createdeco:mossy_${variant_name}_brick_tiles`, `createdeco:mossy_${variant_name}_long_bricks`, `createdeco:mossy_${variant_name}_short_bricks`]
}

//variant_name: The name of the bricks stairs variant
//returns an array of brick stairs variants from create deco
function createdeco_getstairs(variant_name) {
	return [`createdeco:${variant_name}_bricks_stairs`, `createdeco:${variant_name}_brick_tiles_stairs`, `createdeco:${variant_name}_long_bricks_stairs`, `createdeco:${variant_name}_short_bricks_stairs`, `createdeco:cracked_${variant_name}_bricks_stairs`, `createdeco:cracked_${variant_name}_brick_tiles_stairs`, `createdeco:cracked_${variant_name}_long_bricks_stairs`, `createdeco:cracked_${variant_name}_short_bricks_stairs`, `createdeco:mossy_${variant_name}_bricks_stairs`, `createdeco:mossy_${variant_name}_brick_tiles_stairs`, `createdeco:mossy_${variant_name}_long_bricks_stairs`, `createdeco:mossy_${variant_name}_short_bricks_stairs`]
}

//variant_name: The name of the bricks slabs variant
//returns an array of brick slabs variants from create deco
function createdeco_getslabs(variant_name) {
	return [`createdeco:${variant_name}_bricks_slab`, `createdeco:${variant_name}_brick_tiles_slab`, `createdeco:${variant_name}_long_bricks_slab`, `createdeco:${variant_name}_short_bricks_slab`, `createdeco:cracked_${variant_name}_bricks_slab`, `createdeco:cracked_${variant_name}_brick_tiles_slab`, `createdeco:cracked_${variant_name}_long_bricks_slab`, `createdeco:cracked_${variant_name}_short_bricks_slab`, `createdeco:mossy_${variant_name}_bricks_slab`, `createdeco:mossy_${variant_name}_brick_tiles_slab`, `createdeco:mossy_${variant_name}_long_bricks_slab`, `createdeco:mossy_${variant_name}_short_bricks_slab`]
}

//variant_name: The name of the bricks vertical slabs variant
//returns an array of brick vertical slabs variants from create deco
function createdeco_getvertslabs(variant_name) {
	return [`createdeco:${variant_name}_bricks_slab_vert`, `createdeco:${variant_name}_brick_tiles_slab_vert`, `createdeco:${variant_name}_long_bricks_slab_vert`, `createdeco:${variant_name}_short_bricks_slab_vert`, `createdeco:cracked_${variant_name}_bricks_slab_vert`, `createdeco:cracked_${variant_name}_brick_tiles_slab_vert`, `createdeco:cracked_${variant_name}_long_bricks_slab_vert`, `createdeco:cracked_${variant_name}_short_bricks_slab_vert`, `createdeco:mossy_${variant_name}_bricks_slab_vert`, `createdeco:mossy_${variant_name}_brick_tiles_slab_vert`, `createdeco:mossy_${variant_name}_long_bricks_slab_vert`, `createdeco:mossy_${variant_name}_short_bricks_slab_vert`]
}

//variant_name: The name of the bricks walls variant
//returns an array of brick walls variants from create deco
function createdeco_getwalls(variant_name) {
	return [`createdeco:${variant_name}_bricks_wall`, `createdeco:${variant_name}_brick_tiles_wall`, `createdeco:${variant_name}_long_bricks_wall`, `createdeco:${variant_name}_short_bricks_wall`, `createdeco:cracked_${variant_name}_bricks_wall`, `createdeco:cracked_${variant_name}_brick_tiles_wall`, `createdeco:cracked_${variant_name}_long_bricks_wall`, `createdeco:cracked_${variant_name}_short_bricks_wall`, `createdeco:mossy_${variant_name}_bricks_wall`, `createdeco:mossy_${variant_name}_brick_tiles_wall`, `createdeco:mossy_${variant_name}_long_bricks_wall`, `createdeco:mossy_${variant_name}_short_bricks_wall`]
}

//str: The string to modify and return
//returns a string with the first letter of each word in uppercase
function toMultiTitleCase(str) {
	var i,
		frags = str.split("_");
	for (i = 0; i < frags.length; i++) {
		frags[i] = frags[i].charAt(0).toUpperCase() + frags[i].slice(1);
	}
	return frags.join(" ");
}
